<?php
require '../theam/dbconn.php';
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Check for Authorization header
$headers = getallheaders();
$authToken = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authToken !== "123") {
    echo json_encode(["error" => "Unauthorized"]);
    exit;
}

// Get UID
$uid = isset($_GET['uid']) ? $_GET['uid'] : '';

if (empty($uid)) {
    echo json_encode(["error" => "No UID provided"]);
    exit;
}

// Call the search function and get results
$results = search_product($uid);

// Return results
if (!empty($results)) {
    echo json_encode(array_values($results));
} else {
    echo json_encode(["message" => "No results found"]);
}

// Search function to get products
function search_product($uid) {
    global $conn;

    // Use prepared statements to prevent SQL injection
    $sql = "SELECT * FROM pos_bill WHERE uid = ? LIMIT 50";
    $stmt = $conn->prepare($sql);

    // Bind parameters correctly
    $stmt->bind_param('i', $uid);

    // Execute the query
    $stmt->execute();
    
    $result = $stmt->get_result();
    $products = [];
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;  // Add each row to the results array
        }
    }

    $stmt->close(); // Close statement
    return $products;
}