<?php
require '../theam/dbconn.php';
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Check for Authorization header
$headers = getallheaders();
$authToken = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authToken !== "123") {
    echo json_encode(["error" => "Unauthorized"]);
    exit;
}

// Get search query and UID
$search = isset($_GET['q']) ? $_GET['q'] : '';
$uid = isset($_GET['uid']) ? $_GET['uid'] : '';

if (empty($search)) {
    echo json_encode(["error" => "No search query provided"]);
    exit;
}

// Call the search function and get results
$results = search_product($search, $uid);

// Return results
if (!empty($results)) {
    echo json_encode(array_values($results));
} else {
    echo json_encode(["message" => "No results found"]);
}

// Search function to get products
function search_product($search, $uid) {
    global $conn;

    // Use prepared statements to prevent SQL injection
    $sql = "SELECT * FROM pos_bill WHERE uid = ? AND bill_id LIKE ?";
    $stmt = $conn->prepare($sql);

    $searchTerm = '%' . $search . '%'; // For partial matching in LIKE

    // Bind parameters correctly
    $stmt->bind_param('is', $uid, $searchTerm);

    // Execute the query
    $stmt->execute();
    
    $result = $stmt->get_result();
    $products = [];
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;  // Add each row to the results array
        }
    }

    $stmt->close(); // Close statement
    return $products;
}
